//
//  BleCallback.h
//  CodekSDK
//
//  Created by yhb on 2021/3/19.
//

#import <Foundation/Foundation.h>
#import <CoreBluetooth/CoreBluetooth.h>

NS_ASSUME_NONNULL_BEGIN

/**
 *  @enum ConnectState
 *  
 *  @discussion 连接状态(Connection status)
 */
typedef NS_ENUM (NSUInteger,ConnectState) {
    NOT_FOUND_DEVICE,           ///<未找到设备(Device not found)
    CONNECT_STATE_DISCONNECT,   ///<断开连接(Disconnect)
    CONNECT_STATE_CONNECTING,   ///<连接中(Connecting)
    CONNECT_STATE_CONNECTED,    ///<已连接(Connected)
    CONNECT_STATE_TIMEOUT,      ///<连接超时(Connection timeout)
    CONNECT_STATE_FAILT         ///<连接失败(Connection fail)
};

@interface BleCallback : NSObject
/// 设备状态改变的block
/// Callbacks for device state changes
typedef void (^CentralManagerDidUpdateStateBlock)(CBCentralManager *central);
/// 找到设备的block
/// Find the device's callback
typedef void (^DiscoverPeripheralsBlock)(CBCentralManager *central, CBPeripheral *peripheral, NSDictionary *advertisementData, NSNumber *RSSI);
/// 连接设备成功的block
/// A callback for successful connection of the device
typedef void (^ConnectedPeripheralBlock)(CBCentralManager *central, CBPeripheral *peripheral);
/// 连接设备失败的block
/// A callback that failed to connect the device
typedef void (^FailToConnectBlock)(CBCentralManager *central, CBPeripheral *peripheral, NSError *error);
/// 连接设备过程的block
/// A callback to the process of connecting the device
typedef void (^ConnectPeripheralStateBlock)(ConnectState state);
/// 断开设备连接的block
/// A callback that disconnects the device
typedef void (^DisconnectBlock)(CBCentralManager *central, CBPeripheral *peripheral, NSError *error);
/// 写入数据进度的block
/// A callback to the progress of writing data
typedef void (^ReadDataBlock)(NSData * _Nullable data);
/// 读取设备数据的block
/// A callback to read device data
typedef void (^WriteProgressBlock)(NSUInteger total, NSUInteger progress);
#pragma mark - 过滤器Filter
/// 发现peripherals规则
/// Discover the Peripherals rule
typedef BOOL (^FilterOnDiscoverPeripherals)(NSString *peripheralName, NSDictionary *advertisementData, NSNumber *RSSI);

@end

NS_ASSUME_NONNULL_END
